<?php
include 'includes/header.php';
require_once 'config/database.php';

if (isset($_SESSION['user_id'])) {
    redirect('/');
}

if (isset($_POST['register'])) {
    $database = new Database();
    $db = $database->getConnection();
    
    $username = sanitize_input($_POST['username']);
    $email = sanitize_input($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $first_name = sanitize_input($_POST['first_name']);
    $last_name = sanitize_input($_POST['last_name']);
    $phone = sanitize_input($_POST['phone']);
    
    // Check if email or username already exists
    $check_query = "SELECT id FROM users WHERE email = ? OR username = ?";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->execute([$email, $username]);
    
    if ($check_stmt->rowCount() > 0) {
        set_message('Email or username already exists', 'danger');
    } else {
        $query = "INSERT INTO users (username, email, password, first_name, last_name, phone) 
                  VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $db->prepare($query);
        
        if ($stmt->execute([$username, $email, $password, $first_name, $last_name, $phone])) {
            $_SESSION['user_id'] = $db->lastInsertId();
            $_SESSION['is_admin'] = false;
            set_message('Registration successful! Welcome to CarDealer.');
            redirect('/');
        } else {
            set_message('Registration failed. Please try again.', 'danger');
        }
    }
}
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-body p-5">
                    <h2 class="text-center mb-4">Register</h2>
                    
                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Username</label>
                                <input type="text" class="form-control" name="username" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">First Name</label>
                                <input type="text" class="form-control" name="first_name" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Last Name</label>
                                <input type="text" class="form-control" name="last_name" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone</label>
                                <input type="tel" class="form-control" name="phone" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" class="form-control" name="password" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" name="confirm_password" required>
                            </div>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" name="register" class="btn btn-primary">Register</button>
                        </div>
                        
                        <p class="text-center mt-3">
                            Already have an account? <a href="/login.php">Login here</a>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 